@extends('admin.layouts.master')
@section('title',__('Deposit Log'))
@section('content')
    <div class="card">
        <div class="card-body p-0">
            <table class="table s7__table">
                <thead>
                <tr>
                    <th>@lang('Serial')</th>
                    <th>@lang('Name')</th>
                    <th>@lang('Gateway Name')</th>
                    <th>@lang('Amount')</th>
                    <th>@lang('Charge')</th>
                    <th>@lang('USD Amount')</th>
                    <th>@lang('Status')</th>
                    <th>@lang('Transaction ID')</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($deposits as $key => $deposit)
                    <tr>
                        <td>{{$key+1}}</td>
                        <td data-label="Name"><a target="_blank" href="{{route('user.view', $deposit->user_id)}}">{{$deposit->user->name}}</a></td>
                        <td data-label="Email">{{($deposit->gateway->main_name)?$deposit->gateway->main_name:$deposit->gateway->name}}</td>
                        <td data-label="Username">{{round($deposit->amount, 8)}} {{$general->currency}}</td>
                        <td data-label="Mobile">{{round($deposit->charge, 8)}} {{$general->currency}}</td>
                        <td data-label="Balance">{{round($deposit->usd_amo, 8)}} USD</td>
                        <td>
                        @if(isset($deposit->deposit_request_table) && !is_null($deposit->deposit_request_table))
                            @if($deposit->deposit_request_table->accepted == 0)
                                <span class="badge bg-warning">@lang('pending')</span>
                            @elseif($deposit->deposit_request_table->accepted == 1)
                                <span class="badge bg-success">@lang('approved')</span>
                            @else
                                <span class="badge bg-danger">@lang('rejected')</span>
                            @endif
                        @else
                            <span class="badge bg-info">{{($deposit->status==0)?'incomplete':'complete'}}</span>
                        @endif
                        </td>
                        <td  data-label="Details">{{$deposit->trx}}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                {{$deposits->links('pagination::bootstrap-4')}}
            </div>
        </div>
    </div>
@endsection

