<footer class="footer-area style-2 bg-cover bg-base pd-top-110 mt-0">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-6">
                <div class="widget widget_about">
                    <div class="thumb mb-2">
                        <img src="{{asset('public/images/logo/logo.png')}}" alt="img">
                    </div>
                    <div class="details">
                        <p>{{$general->footer_text}}</p>
                        <h6 class="text-white mt-3">
                            <i class="fa fa-map-marker-alt"></i>
                            <span class="ps-1">{{$general->contact_address}}</span>
                        </h6>
                        <h6 class="text-white mt-2">
                            <i class="fa fa-phone"></i>
                            <span class="ps-1">{{$general->contact_phone}}</span>
                        </h6>
                        <h6 class="text-white mt-2">
                            <i class="far fa-envelope"></i>
                            <span class="ps-1">{{$general->contact_email}}</span>
                        </h6>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 ps-xl-5">
                <div class="widget widget_nav_menu">
                    <h4 class="widget-title">{{__('Links')}}</h4>
                    <ul>
                        <li><a href="{{route('news.index')}}">{{__('Blog')}}</a></li>
                        <li><a href="{{route('contacts.index')}}">{{__('Contact')}}</a></li>
                        @guest
                        <li><a href="{{route('register')}}">{{__('Sign Up')}}</a></li>
                        <li><a href="{{route('login')}}">{{__('Sign In')}}</a></li>
                        @else
                            <li><a href="{{route('home')}}">{{__('Dashboard')}}</a></li>
                        @endguest
                    </ul>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="widget widget_nav_menu">
                    <h4 class="widget-title">{{__('Others Links')}}</h4>
                    <ul>
                        @foreach($frontMenu as $data)
                            <li><a href="{{route('single.page',['class' => $data->slug, 'id' =>$data->id])}}">{{__($data->title)}}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="widget widget-recent-post">
                    <h4 class="widget-title">{{__('Recent News')}}</h4>
                    <ul>
                        @foreach($recentPost->take(2) as $data)
                        <li>
                            <div class="media">
                                <div class="media-left">
                                    <img class="foot-blog-img" src="{{asset('public/images/news/'.$data->image)}}" alt="blog">
                                </div>
                                <div class="media-body align-self-center">
                                    <h6 class="title"><a href="{{route('single.page',['class' => 'news','id'=>$data->id])}}">{{__($data->title)}}</a></h6>
                                    <div class="post-info"><i class="far fa-calendar-alt"></i><span>{{date('M d, Y',strtotime($data->updated_at))}}</span></div>                     
                                </div>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom bg-black-2 mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center align-self-center">
                    <p>{{__($general->copyright_text)}}</p>
                </div>
            </div>
        </div>
    </div>
</footer>

<div class="back-to-top">
    <span class="back-top"><i class="fa fa-angle-up"></i></span>
</div>